/*
    Copyright (c) 2002, bDistributed.com, Inc.
    All rights reserved.

    Redistribution and use in source and binary forms, with or
    without modification, are permitted provided that the following
    conditions are met:

    *   Redistributions of source code must retain the above
        copyright notice, this list of conditions and the following
        disclaimer.
    
    *   Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials
        provided with the distribution.
    
    *   Neither the name of bDistributed.com, Inc. nor the names of
        its contributors may be used to endorse or promote products
        derived from this software without specific prior written
        permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
    CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
    OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
    OF SUCH DAMAGE.
*/

#import <Foundation/Foundation.h>
#import "BDQualifier.h"


@interface BDKeyValueQualifier : BDQualifier <BDQualifierEvaluation, NSCoding>
{
    NSString *_key;
    SEL _selector;
    id _value;

    NSArray *_keyParts;
}

+ (BDKeyValueQualifier*)keyValueQualifierWithKey:(NSString *)key operatorSelector:(SEL)selector value:(id)value;

// Used for taking a EO comparison selector and returning a BD one (they seem to be the same, but...)
+ (SEL)replacementSelectorForEOSelectorName:(NSString *)aName;


- (id)initWithKey:(NSString *)key operatorSelector:(SEL)selector value:(id)value;
- (void)dealloc;

- (NSString *)description;
- (NSString*)treeDescription;

- (BOOL)evaluateWithObject:(id)object;
- (BOOL)_processObject: (id)object withKeyPartIndex: (int)index;
- (BOOL)_processArray: (NSArray *)array withKeyPartIndex: (int)index;
- (BOOL)_evaluateWithObject:(id)target;

- (void)addQualifierKeysToSet:(NSMutableSet *)qualKeys;

- (NSString *)key;
- (void)setKey:(NSString *)aKey;
- (SEL)selector;
- (id)value;
- (void)setValue:(id)aValue;
- (NSArray *)keyParts;

- (NSArray *)bindingKeys;
- (NSString *)keyPathForBindingKey:(NSString *)key;

/* NSCoding Protocol */

- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;

@end
